<?php  
	function lcw_load_teams($teams_list)
	{
		ob_start();
?>
	<section class="ulcwp-team">
		<div class="ulcwp-custom-tabs">
			<ul id="myTab" role="tablist" class="nav nav-tabs">
				<li class="nav-item active">
					<a id="internation-tab" data-toggle="tab" href="#internation" role="tab" aria-controls="internation" aria-selected="false" class="nav-link text-uppercase">International</a>
				</li>
				<li class="nav-item">
					<a id="leagues-tab" data-toggle="tab" href="#leagues" role="tab" aria-controls="leagues" aria-selected="false" class="nav-link text-uppercase">other Leagues</a>
				</li>
			</ul>
			<div id="myTabContent" class="tab-content" style="margin-top: 15px;">
				<div id="internation" role="tabpanel" aria-labelledby="internation-tab" class="tab-pane active">
					<div class="ulcwp-team-wrap">
						<div class="row">
							<?php foreach ($teams_list->international->mens as $team) { ?>
								<div class="col-lg-4 col-sm-6">
									<div class="ulcwp-team-card">
										<a href="<?php echo home_url('team/'.strtolower( $team->teamShortName ).'/'.$team->teamID); ?>">
											<div class="ulcwp-team-banner">
												<img src="https://www.cricket.com/_next/image?url=https://images.cricket.com/teams/<?php echo $team->teamID ?>_actionshot_safari.jpg&w=3840&q=75" alt=""  onerror="this.onerror=null;this.src='https://www.cricket.com/svgs/images/flag_empty.svg';">
											</div>
											<div class="ulcwp-team-content">
												<h4><?php echo $team->teamName ?></h4>
												<div class="ulcwp-team-ranking-info">
													<h5>ICC Ranking</h5>
													<div class="ulcwp-comp-format-info">
														<div class="ulcwp-comp-format-inner ulcwp-d-flex ulcwp-align-items-center ulcwp-justify-content-center">
															<div class="ulcwp-comp-format-detail">
																<p>TEST <span><?php echo $team->testRanking ?></span></p>
															</div>
															<div class="ulcwp-comp-format-detail">
																<p>T20s <span><?php echo $team->t20Ranking ?></span></p>
															</div>
															<div class="ulcwp-comp-format-detail">
																<p>ODIs <span><?php echo $team->odiRanking ?></span></p>
															</div>
														</div>
													</div>
												</div>
											</div>
										</a>
									</div>
								</div>
							<?php } ?>
						</div>
					</div>
				</div>
				<div id="leagues" role="tabpanel" aria-labelledby="leagues-tab" class="tab-pane">
					<div class="ulcwp-custom-tabs ulcwp-tabs-style2">
						<ul role="tablist" class="nav nav-tabs">
							<li class="nav-item active">
								<a id="IPL-tab" data-toggle="tab" href="#IPL" role="tab" aria-controls="IPL" aria-selected="false" class="nav-link">IPL</a>
							</li>
							<li class="nav-item">
								<a id="BBL-tab" data-toggle="tab" href="#BBL" role="tab" aria-controls="BBL" aria-selected="false" class="nav-link">BBL</a>
							</li>
							<li class="nav-item">
								<a id="CPL-tab" data-toggle="tab" href="#CPL" role="tab" aria-controls="CPL" aria-selected="false" class="nav-link">CPL</a>
							</li>
							<li class="nav-item">
								<a id="PSL-tab" data-toggle="tab" href="#PSL" role="tab" aria-controls="PSL" aria-selected="false" class="nav-link">PSL</a>
							</li>
						</ul>
						<div id="myTabContent" class="tab-content">
							<div id="IPL" role="tabpanel" aria-labelledby="IPL-tab" class="tab-pane active">
								<div class="ulcwp-team-wrap">
									<div class="row">
										<?php foreach ($teams_list->otherLeagues->ipl as $team) { ?>
											<div class="col-lg-4 col-sm-6">
												<div class="ulcwp-team-card">
													<a href="<?php echo home_url('team/'.strtolower( $team->teamShortName ).'/'.$team->teamID); ?>">
														<div class="ulcwp-team-banner">
															<img src="https://www.cricket.com/_next/image?url=https://images.cricket.com/teams/<?php echo $team->teamID ?>_actionshot_safari.jpg&w=3840&q=75" alt=""  onerror="this.onerror=null;this.src='https://www.cricket.com/svgs/images/flag_empty.svg';">
														</div>
														<div class="ulcwp-team-content">
															<h4><?php echo $team->teamName ?></h4>
															<div class="ulcwp-team-ranking-info">
																<h5>Trophies</h5>
																<div class="ulcwp-comp-format-info">
																	<div class="ulcwp-comp-format-inner ulcwp-d-flex ulcwp-align-items-center ulcwp-justify-content-center">
																		<?php if(!empty($team->trophy_details)): ?>
																		<div class="ulcwp-comp-format-detail">
																			<?php echo $team->trophy_details[0]; ?>
																		</div>
																		<?php else: ?>
																		<div class="ulcwp-comp-format-detail">
																			N/A
																		</div>
																	<?php endif; ?>
																	</div>
																</div>
															</div>
														</div>
													</a>
												</div>
											</div>
										<?php } ?>
									</div>
								</div>
							</div>
							<div id="BBL" role="tabpanel" aria-labelledby="BBL-tab" class="tab-pane">
								<div class="ulcwp-team-wrap">
									<div class="row">
										<?php foreach ($teams_list->otherLeagues->bbl as $team) { ?>
											<div class="col-lg-4 col-sm-6">
												<div class="ulcwp-team-card">
													<a href="<?php echo home_url('team/'.strtolower( $team->teamShortName ).'/'.$team->teamID); ?>">
														<div class="ulcwp-team-banner">
															<img src="https://www.cricket.com/_next/image?url=https://images.cricket.com/teams/<?php echo $team->teamID ?>_actionshot_safari.jpg&w=3840&q=75" alt=""  onerror="this.onerror=null;this.src='https://www.cricket.com/svgs/images/flag_empty.svg';">
														</div>
														<div class="ulcwp-team-content">
															<h4><?php echo $team->teamName ?></h4>
															<div class="ulcwp-team-ranking-info">
																<h5>Trophies</h5>
																<div class="ulcwp-comp-format-info">
																	<div class="ulcwp-comp-format-inner ulcwp-d-flex ulcwp-align-items-center ulcwp-justify-content-center">
																		<?php if(!empty($team->trophy_details)): ?>
																		<div class="ulcwp-comp-format-detail">
																			<?php echo $team->trophy_details[0]; ?>
																		</div>
																		<?php else: ?>
																		<div class="ulcwp-comp-format-detail">
																			N/A
																		</div>
																	<?php endif; ?>
																	</div>
																</div>
															</div>
														</div>
													</a>
												</div>
											</div>
										<?php } ?>
									</div>
								</div>
							</div>
							<div id="CPL" role="tabpanel" aria-labelledby="CPL-tab" class="tab-pane">
								<div class="ulcwp-team-wrap">
									<div class="row">
										<?php foreach ($teams_list->otherLeagues->cpl as $team) { ?>
											<div class="col-lg-4 col-sm-6">
												<div class="ulcwp-team-card">
													<a href="<?php echo home_url('team/'.strtolower( $team->teamShortName ).'/'.$team->teamID); ?>">
														<div class="ulcwp-team-banner">
															<img src="https://www.cricket.com/_next/image?url=https://images.cricket.com/teams/<?php echo $team->teamID ?>_actionshot_safari.jpg&w=3840&q=75" alt=""  onerror="this.onerror=null;this.src='https://www.cricket.com/svgs/images/flag_empty.svg';">
														</div>
														<div class="ulcwp-team-content">
															<h4><?php echo $team->teamName ?></h4>
															
														</div>
													</a>
												</div>
											</div>
										<?php } ?>
									</div>
								</div>
							</div>
							<div id="PSL" role="tabpanel" aria-labelledby="PSL-tab" class="tab-pane">
								<div class="ulcwp-team-wrap">
									<div class="row">
										<?php foreach ($teams_list->otherLeagues->psl as $team) { ?>
											<div class="col-lg-4 col-sm-6">
												<div class="ulcwp-team-card">
													<a href="<?php echo home_url('team/'.strtolower( $team->teamShortName ).'/'.$team->teamID); ?>">
														<div class="ulcwp-team-banner">
															<img src="https://www.cricket.com/_next/image?url=https://images.cricket.com/teams/<?php echo $team->teamID ?>_actionshot_safari.jpg&w=3840&q=75" alt=""  onerror="this.onerror=null;this.src='https://www.cricket.com/svgs/images/flag_empty.svg';">
														</div>
														<div class="ulcwp-team-content">
															<h4><?php echo $team->teamName ?></h4>
															
														</div>
													</a>
												</div>
											</div>
										<?php } ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
<?php
	$content = ob_get_clean();

	return $content;

	}

?>