<?php  
function lcw_load_player_stats( $current,$player_stats_list ){
	
	ob_start();
	//print_r($player_stats_list);
	$player_id 	 = $player_stats_list->data->getPlayersProfileV2->playerID;
	$player_name = str_replace( ' ', '-',strtolower($player_stats_list->data->getPlayersProfileV2->name ) );
		
	if(!empty( $player_stats_list ) ){
		
?>
	<div class="ulcwp-player-profile">
	    <div class="player-profile-card ulcwp-d-flex ulcwp-align-items-center">
	      	<div class="player-image-wrap">
		      	<div class="player-image">
		        	<img src="https://images.cricket.com/players/<?php echo $player_id ?>_headshot_safari.png" onerror="this.onerror=null;this.src='https://www.cricket.com/placeHodlers/playerAvatar.png';" alt="<?php echo $player_stats_list->data->getPlayersProfileV2->name  ?>">
		        	<div class="player-badge"><img src="<?php echo plugins_url( 'images/'.str_replace(' ', '-', strtolower($player_stats_list->data->getPlayersProfileV2->role ) ).'.png', dirname(__FILE__) ) ?>"></div>
	      		</div>
	      	</div>
	      	<div class="player-data">
		        <div class="team-name ulcwp-d-flex ulcwp-align-items-center">
		          <img src="https://images.cricket.com/teams/<?php echo $player_stats_list->data->getPlayersProfileV2->teamID ?>_flag_safari.png" alt=""  onerror="this.onerror=null;this.src='https://www.cricket.com/svgs/images/flag_empty.svg';" alt="">
		          <span class="player-team">
		          	<?php 
		          		if(!empty( $player_stats_list->data->getPlayersProfileV2->birthPlace )){ 
		          		
		          			echo $player_stats_list->data->getPlayersProfileV2->birthPlace;
		          		} 
		          	?>
		          </span>
		        </div>
		        <div class="player-name">
		          	<h4>
			          	<?php 
			          		if(!empty( $player_stats_list->data->getPlayersProfileV2->name )){ 
			          		
			          			echo $player_stats_list->data->getPlayersProfileV2->name;
			          		} 
			          	?>
		          	</h4>
		        </div>
		        <div class="player-short-detail">
		          	<p>
		          	DOB:
			          	<span>
				          	<?php 
				          		//$tz  = new DateTimeZone('UTC');
				          		echo $player_stats_list->data->getPlayersProfileV2->dob;
								
		  					?>
		  				</span>
		           	</p>
		          	<p>Batting Style: 
			          	<span>
				          	<?php 
				          		if(!empty( $player_stats_list->data->getPlayersProfileV2->battingStyle )){ 
				          		
				          			echo $player_stats_list->data->getPlayersProfileV2->battingStyle;
				          		} 
				          	?>
			          	</span>
			        </p>
		          	<p>Bowling Style: 
			          	<span>
			          		<?php 
				          		if(!empty( $player_stats_list->data->getPlayersProfileV2->bowlingStyle )){ 
				          		
				          			echo $player_stats_list->data->getPlayersProfileV2->bowlingStyle;
				          		} 
				          	?>
			          	</span>
			        </p>
		        </div>
	      	</div>
	    </div>
  	</div>
  	<div class="ulcwp-custom-tabs mt-20">
        <ul id="myTab" role="tablist" class="nav nav-tabs">
          <li class="nav-item <?php echo get_query_var('type') == 'career-stats' || !get_query_var('type') ? "active" : '' ?>">
            <a id="live-tab" href="<?php echo home_url('stats/'.$player_name.'/'.$player_id.'/career-stats'); ?>" class="nav-link">Career</a>
          </li>
          <li class="nav-item <?php echo get_query_var('type') == 'recent' ? "active" : '' ?>">
            <a id="upcoming-tab" href="<?php echo home_url('stats/'.$player_name.'/'.$player_id.'/recent') ?>" class="nav-link">Recent</a>
          </li>
          <li class="nav-item <?php echo get_query_var('type') == 'fantasy' ? "active" : '' ?>">
            <a id="result-tab" href="<?php echo home_url('stats/'.$player_name.'/'.$player_id.'/fantasy') ?>" class="nav-link">Fantasy</a>
          </li>
        </ul>
    </div>
   
    <?php if((get_query_var('type') == "career-stats") || !get_query_var('type') ): ?>
    	<div class="ulcwp-custom-tabs ulcwp-tabs-style2">
	    	<ul role="tablist" class="nav nav-tabs">
				<li class="nav-item active">
					<a id="batting-tab" data-toggle="tab" href="#batting" role="tab" aria-controls="batting" aria-selected="false" class="nav-link">Batting Stats</a>
				</li>
				<?php if($player_stats_list->data->getPlayersProfileV2->role != 'Wicket Keeper'): ?>
				<li class="nav-item">
					<a id="bowling-tab" data-toggle="tab" href="#bowling" role="tab" aria-controls="bowling" aria-selected="false" class="nav-link">Bowling Stats</a>
				</li>
				<?php endif; ?>
				<?php if($player_stats_list->data->getPlayersProfileV2->role == 'Wicket Keeper'): ?>
				<li class="nav-item">
					<a id="keeper-tab" data-toggle="tab" href="#keeper" role="tab" aria-controls="keeper" aria-selected="false" class="nav-link">Keeper Stats</a>
				</li>
				<?php endif; ?>
			</ul>
	    </div>
	    <div class="tab-content" id="myTabContent">
		    <div role="tabpanel" class="tab-pane active" id="batting">
		    	<?php  
				if(!empty($player_stats_list->data->getPlayersProfileV2->battingStats)){ 

					foreach ($player_stats_list->data->getPlayersProfileV2->battingStats as $statistic ) {
						if(!empty($statistic->matches)): 
				?>
							<div class="lcw-table lcw-batsmen">
						      	<div class="lcw-thead">
						      		
								        <div class="lcw-tr">
								          <div class="lcw-td"><?php echo isset( $statistic->format ) ? $statistic->format : ''  ?></div>
								          <div class="lcw-td">Ings</div>
								          <div class="lcw-td hidden-xs hidden-sm">BF</div>
								          <div class="lcw-td hidden-xs hidden-sm">NT</div>
								          <div class="lcw-td">R</div>
								          <div class="lcw-td  hidden-xs hidden-sm">50s/100s</div>
								          <div class="lcw-td  hidden-xs hidden-sm">Avg</div>
								          <div class="lcw-td  hidden-xs hidden-sm">SR</div>
								          <div class="lcw-td  hidden-xs hidden-sm">4s/6s</div>
								        </div>
							        
						      	</div>
						      	<div class="lcw-tbody">
						    		
							        <div class="lcw-tr">
							            <div class="lcw-td" data-title="<?php echo isset( $statistic->format ) ? $statistic->format : ''  ?>">

											<?php 
												echo isset( $statistic->matches )  ? $statistic->matches : ''  
											?>
							            </div>
							          	<div class="lcw-td" data-title="Ings"><?php echo isset( $statistic->innings ) ? $statistic->innings : '' ?>
							          		
							          	</div>
							          	<div class="lcw-td hidden-xs hidden-sm" data-title="Ball Faced"><?php echo isset( $statistic->ballsFaced ) ? $statistic->ballsFaced : ''  ?></div>
							          	<div class="lcw-td hidden-xs hidden-sm" data-title="Not Out"><?php echo isset( $statistic->notOuts ) ? $statistic->notOuts : ''   ?>
							          		
							          	</div>
							          	<div class="lcw-td" data-title="Runs"><?php echo isset( $statistic->runs ) ? $statistic->runs : ''  ?>
							          		
							          	</div>
							          	<div class="lcw-td hidden-xs hidden-sm" data-title="50s/100s"><?php echo isset( $statistic->hundredsfifties ) ? $statistic->hundredsfifties : ''  ?>
							          		
							          	</div>
							          	
							          	<div class="lcw-td  hidden-xs hidden-sm" data-title="Average"><?php echo isset( $statistic->average ) ? $statistic->average : '' ?></div>
							          	<div class="lcw-td  hidden-xs hidden-sm" data-title="Strike Rate">
							          		<?php echo isset( $statistic->strikeRate ) ? $statistic->strikeRate : '' ?>
							          		
							          	</div>
							          	<div class="lcw-td  hidden-xs hidden-sm" data-title="4s/6s">
							          		<?php echo isset( $statistic->foursix ) ? $statistic->foursix : ''  ?>
							          		
							          	</div>
							        </div>
						    		
						      	</div>
						    </div>
				<?php endif; ?>
				<?php
						}
					}else{

						echo "<p>No stats at the moment!</p>";
					} 
				?>
		    </div>
		    <div role="tabpanel" class="tab-pane" id="bowling">
		    	<?php  
				if(!empty($player_stats_list->data->getPlayersProfileV2->bowlingStats)){ 

					foreach ($player_stats_list->data->getPlayersProfileV2->bowlingStats as $statistic ) {
						if(!empty($statistic->matches)): 
				?>
							<div class="lcw-table lcw-batsmen">
						      	<div class="lcw-thead">
						      		
								        <div class="lcw-tr">
								          <div class="lcw-td"><?php echo isset( $statistic->format ) ? $statistic->format : ''  ?></div>
								          <div class="lcw-td">Ings</div>
								          <div class="lcw-td hidden-xs hidden-sm">Overs</div>
								          <div class="lcw-td hidden-xs hidden-sm">Balls</div>
								          <div class="lcw-td">Wkts</div>
								          <div class="lcw-td  hidden-xs hidden-sm">BBI</div>
								          <div class="lcw-td  hidden-xs hidden-sm">Avg</div>
								          <div class="lcw-td  hidden-xs hidden-sm">Econ</div>
								          <div class="lcw-td  hidden-xs hidden-sm">SR</div>
								          <div class="lcw-td  hidden-xs hidden-sm">5w</div>
								        </div>
							        
						      	</div>
						      	<div class="lcw-tbody">
						    		
							        <div class="lcw-tr">
							            <div class="lcw-td" data-title="<?php echo isset( $statistic->format ) ? $statistic->format : ''  ?>">

											<?php 
												echo isset( $statistic->matches )  ? $statistic->matches : '-'  
											?>
							            </div>
							          	<div class="lcw-td" data-title="Ings"><?php echo isset( $statistic->innings ) ? $statistic->innings : '' ?>
							          		
							          	</div>
							          	<div class="lcw-td hidden-xs hidden-sm" data-title="Overs Bowled"><?php echo isset( $statistic->overs ) ? $statistic->overs : ''  ?></div>
							          	<div class="lcw-td hidden-xs hidden-sm" data-title="Balls Bowled"><?php echo isset( $statistic->ballsBowled ) ? $statistic->ballsBowled : '-'  ?></div>
							          	<div class="lcw-td hidden-xs hidden-sm" data-title="Wickets"><?php echo isset( $statistic->wickets ) ? $statistic->wickets : '-'   ?>
							          		
							          	</div>
							          	
							          	<div class="lcw-td hidden-xs hidden-sm" data-title="Best Bowling"><?php echo isset( $statistic->bestBowling ) ? $statistic->bestBowling : '-'  ?>
							          		
							          	</div>
							          	
							          	<div class="lcw-td  hidden-xs hidden-sm" data-title="Average"><?php echo isset( $statistic->average ) ? $statistic->average : '' ?></div>
							          	<div class="lcw-td  hidden-xs hidden-sm" data-title="Strike Rate">
							          		<?php echo isset( $statistic->strikeRate ) ? $statistic->strikeRate : '-' ?>
							          		
							          	</div>
							          	<div class="lcw-td  hidden-xs hidden-sm" data-title="Economy Rate">
							          		<?php echo isset( $statistic->economyRate ) ? $statistic->economyRate : '-' ?>
							          	</div>
							          	<div class="lcw-td  hidden-xs hidden-sm" data-title="Five Wicket Hauls">
							          		<?php echo isset( $statistic->fiveWicketHauls ) ? $statistic->fiveWicketHauls : '-'  ?>
							          	</div>
							        </div>
						    		
						      	</div>
						    </div>
				<?php endif; ?>
				<?php
						}
					}else{

						echo "<p>No stats at the moment!</p>";
					} 
				?>
		    </div>
		    <div role="tabpanel" class="tab-pane" id="keeper">
		    	<?php  
				if(!empty($player_stats_list->data->getPlayersProfileV2->fieldingStats)){ 

					foreach ($player_stats_list->data->getPlayersProfileV2->fieldingStats as $statistic ) {
						//if(!empty($statistic->matches)): 
				?>
							<div class="lcw-table lcw-batsmen">
						      	<div class="lcw-thead">
							        <div class="lcw-tr">
							          	<div class="lcw-td">
							          	Format
							          	</div>
							          	<div class="lcw-td">Catches</div>
							          	<div class="lcw-td">Stupms</div>
							          	<div class="lcw-td">Run Outs</div>							       
							        </div>
						      	</div>
						      	<div class="lcw-tbody">
							        <div class="lcw-tr">
							        	<div class="lcw-td">
							        		<?php echo !empty( $statistic->format ) ? $statistic->format : ''  ?>
							          	</div>
							          	<div class="lcw-td" data-title="Catches"><?php echo !empty( $statistic->catches ) ? $statistic->catches : '' ?>
							          	</div>
							          	<div class="lcw-td" data-title="Stupms"><?php echo !empty( $statistic->stupms ) ? $statistic->stupms : ''  ?></div>
							          	<div class="lcw-td" data-title="Run Outs"><?php echo !empty( $statistic->runOuts ) ? $statistic->runOuts : ''  ?></div>
							        </div>
						      	</div>
						    </div>
				
				<?php
						}
					}else{

						echo "<p>No stats at the moment!</p>";
					} 
				?>
		    </div>
		</div>
		<?php 
			elseif(get_query_var('type') == "recent"): 

			$player_matches_content    =  $current->lcw_get_content('{"query":"query getPlayerMatches($playerID: String!) {\\n  getPlayerMatches(playerID: $playerID) {\\n    all {\\n      homeTeamShortName\\n      awayTeamShortName\\n      homeTeamID\\n      awayTeamID\\n      matchDate\\n      matchID\\n      matchType\\n      opposition\\n      battingStats\\n      bowlingStats\\n    }\\n    t20 {\\n      homeTeamShortName\\n      awayTeamShortName\\n      homeTeamID\\n      awayTeamID\\n      matchDate\\n      matchID\\n      matchType\\n      opposition\\n      battingStats\\n      bowlingStats\\n    }\\n    odi {\\n      homeTeamShortName\\n      awayTeamShortName\\n      homeTeamID\\n      awayTeamID\\n      matchDate\\n      matchID\\n      matchType\\n      opposition\\n      battingStats\\n      bowlingStats\\n    }\\n    test {\\n      homeTeamShortName\\n      awayTeamShortName\\n      homeTeamID\\n      awayTeamID\\n      matchDate\\n      matchID\\n      matchType\\n      opposition\\n      battingStats\\n      bowlingStats\\n    }\\n    t20Domestic {\\n      homeTeamShortName\\n      awayTeamShortName\\n      homeTeamID\\n      awayTeamID\\n      matchDate\\n      matchID\\n      matchType\\n      opposition\\n      battingStats\\n      bowlingStats\\n    }\\n  }\\n}","variables":{"playerID":"'.$player_id.'"}}');
          $player_matches_list       =  json_decode( $player_matches_content);
		?>
		<div class="ulcwp-custom-tabs ulcwp-tabs-style2 ulcwp-tabs-recent">
	    	<ul role="tablist" class="nav nav-tabs">
	    		<?php 
    			if(!empty($player_matches_list->data->getPlayerMatches)){ 
    				$i = 0;
					foreach ($player_matches_list->data->getPlayerMatches as $matches_type => $matches_data) { ?>
						<li class="nav-item <?php echo $i == 0 ? 'active' : '' ?>">
							<a id="<?php echo $matches_type ?>-tab" data-toggle="tab" href="#<?php echo $matches_type ?>" role="tab" aria-controls="<?php echo $matches_type ?>" aria-selected="false" class="nav-link"><?php echo strtoupper( $matches_type ) ?></a>
						</li>
				<?php 
					$i++;
					} 

				}
				?>
			</ul>
	    </div>
	    <div class="tab-content" id="myTabContent">
	    	<?php 
    			if(!empty($player_matches_list->data->getPlayerMatches)){ 
    				$i = 0;
					foreach ($player_matches_list->data->getPlayerMatches as $matches_type => $matches_data) { ?>
				    	<div role="tabpanel" class="tab-pane <?php echo $i == 0 ? 'active' : '' ?>" id="<?php echo $matches_type ?>">
							<div class="lcw-table lcw-batsmen lcw-profile-table">
						      	<div class="lcw-thead">
							        <div class="lcw-tr">
							          <div class="lcw-td">Opposition</div>
							          <div class="lcw-td">Batting</div>
							          <div class="lcw-td">Bowling</div>
							          <?php if($matches_type == 'all'): ?>
							          	<div class="lcw-td">Format</div>
							          <?php endif; ?>
							          <div class="lcw-td">Date</div>
							        </div>
						      	</div>
						      	<div class="lcw-tbody">
						    		<?php 
						    			if(!empty($player_matches_list->data->getPlayerMatches->{$matches_type})){ 

											foreach ($player_matches_list->data->getPlayerMatches->{$matches_type} as $all_matches ) { ?>
										        <div class="lcw-tr">
										            <div class="lcw-td">
										            	<a href="<?php echo home_url('live-score/'.strtolower( str_replace(' ', '-', $all_matches->opposition) ).'-'.strtolower($all_matches->matchType).'/'.$all_matches->matchID.'/completed/?view=summary') ?>">
										            		<?php echo $all_matches->opposition; ?>
														</a>
										            </div>
										          	<div class="lcw-td"><?php echo $all_matches->battingStats ?></div>
										          	<div class="lcw-td"><?php echo $all_matches->bowlingStats  ?></div>
										          	<?php if($matches_type == 'all'): ?>
										          		<div class="lcw-td"><?php echo $all_matches->matchType   ?></div>
										          	<?php endif; ?>
										          	<div class="lcw-td">
										          		<?php 

						                                    $datetimeFormat = 'F d, Y';

						                                      //$date = new \DateTime();
						                                      // If you must have use time zones
						                                    $date = new \DateTime('now', new DateTimeZone('UTC') );

						                                    $loc = (new DateTime)->getTimezone();

						                                      // change the timezone of the object without changing its time
						                                    $date->setTimezone($loc);
						                                      //echo substr($single_series->seriesStartDate, 0, -3);
						                                    $date->setTimestamp(substr($all_matches->matchDate, 0, -3));
						                                      
						                                    echo $date->format($datetimeFormat);
					                                    ?>
										          	</div>
										        </div>
									<?php } } ?>
						      	</div>
						    </div>
						</div>
			<?php $i++; } } ?>
		</div>
		<?php 
			elseif(get_query_var('type') == "fantasy"): 
				$player_fantasy_content    =  $current->lcw_get_content('{"query":"query getPlayerFantasyMatches($playerID: String!) {\\n  getPlayerFantasyMatches(playerID: $playerID) {\\n    t20 {\\n      opposition\\n      battingStats\\n      bowlingStats\\n      points\\n      isDreamTeam\\n      matchType\\n    }\\n    test {\\n      opposition\\n      battingStats\\n      bowlingStats\\n      points\\n      isDreamTeam\\n      matchType\\n    }\\n    odi {\\n      opposition\\n      battingStats\\n      bowlingStats\\n      points\\n      isDreamTeam\\n      matchType\\n    }\\n    t20Domestic {\\n      opposition\\n      battingStats\\n      bowlingStats\\n      points\\n      isDreamTeam\\n      matchType\\n    }\\n    all {\\n      opposition\\n      battingStats\\n      bowlingStats\\n      points\\n      isDreamTeam\\n      matchType\\n    }\\n  }\\n}\\n","variables":{"playerID":"'.$player_id.'"}}');
          		$player_fantasy_list       =  json_decode( $player_fantasy_content);

        ?>
        <div class="ulcwp-custom-tabs ulcwp-tabs-style2 ulcwp-tabs-recent">
	    	<ul role="tablist" class="nav nav-tabs">
	    		<?php 
    			if(!empty($player_fantasy_list->data->getPlayerFantasyMatches)){ 
    				$i = 0;
					foreach ($player_fantasy_list->data->getPlayerFantasyMatches as $matches_type => $matches_data) { ?>
						<li class="nav-item <?php echo $i == 0 ? 'active' : '' ?>">
							<a id="<?php echo $matches_type ?>-tab" data-toggle="tab" href="#<?php echo $matches_type ?>" role="tab" aria-controls="<?php echo $matches_type ?>" aria-selected="false" class="nav-link"><?php echo strtoupper( $matches_type ) ?></a>
						</li>
				<?php 
					$i++;
					} 

				}
				?>
			</ul>
	    </div>
	    <div class="tab-content" id="myTabContent">
	    	<?php 
    			if(!empty($player_fantasy_list->data->getPlayerFantasyMatches)){ 
    				$i = 0;
					foreach ($player_fantasy_list->data->getPlayerFantasyMatches as $matches_type => $matches_data) { ?>
				    	<div role="tabpanel" class="tab-pane <?php echo $i == 0 ? 'active' : '' ?>" id="<?php echo $matches_type ?>">
					        <div class="lcw-table lcw-batsmen lcw-profile-table">
						      	<div class="lcw-thead">
							        <div class="lcw-tr">
							          <div class="lcw-td">Opposition</div>
							          <div class="lcw-td">Batting</div>
							          <div class="lcw-td">Bowling</div>
							          <div class="lcw-td">Points</div>
							          <div class="lcw-td">DTA</div>
							        </div>
						      	</div>
						      	<div class="lcw-tbody">
						      		<?php 
						    			if(!empty($player_fantasy_list->data->getPlayerFantasyMatches->{$matches_type})){ 

											foreach ($player_fantasy_list->data->getPlayerFantasyMatches->{$matches_type} as $all_matches ) { ?>
										        <div class="lcw-tr">
										            <div class="lcw-td">
										            	<?php echo $all_matches->opposition; ?>
										            </div>
										          	<div class="lcw-td"><?php echo $all_matches->battingStats ?></div>
										          	<div class="lcw-td"><?php echo $all_matches->bowlingStats  ?></div>
										          	<div class="lcw-td"><?php echo $all_matches->points   ?></div>
										          	<div class="lcw-td">
										          		<?php 
										          			if($all_matches->isDreamTeam){

										          				$bg = "bg-green";

										          			}else{

										          				$bg = "bg-red";
										          			}
										          		?>
										          		<div class="<?php echo $bg; ?> bg-circle"></div>
										          	</div>
										        </div>
									<?php } } ?>
						      	</div>
							</div>
						</div>
				<?php $i++; } }  ?>
	<?php endif; ?>
	<?php
	} 
	return ob_get_clean();
}