<?php
    function lcw_load_series_list_3( $series_list,$col,$type  ){
      ob_start();
?>
      <div class="ulcwp-custom-tabs">
        <ul id="myTab" class="nav nav-tabs" role="tablist">
            
            <li class="nav-item <?php echo get_query_var('tab') == 'upcoming' ? "active" : '' ?>">

              <a  href="<?php echo home_url('series/upcoming') ?>" class="nav-link">Upcoming</a>

            </li>
            <li class="nav-item <?php echo get_query_var('tab') == 'live' || !get_query_var('tab') ? "active" : '' ?>">

              <a href="<?php echo home_url('series/live') ?>" class="nav-link">Live</a>
              
            </li>
            <li class="nav-item <?php echo get_query_var('tab') == 'completed' ? "active" : '' ?>">

              <a href="<?php echo home_url('series/completed') ?>" class="nav-link">Completed</a>

            </li>
        </ul>
      </div>
      <div class="ulcwp-series-wrap">
        <?php 
          if(!empty($series_list)){

              foreach ($series_list as $single_series) {
              
                $series_name = str_replace( " ", "-", str_replace( ",","",strtolower( $single_series->tourName ) ) );
        ?>
                <div class="ulcwp-series-card">
                  <a href="<?php echo home_url($series_name.'/'.$single_series->tourID.'/matches' )?>">
                    <div class="ulcwp-series-card-inner ulcwp-d-flex ulcwp-justify-content-between">
                      <div class="ulcwp-series-left-sec ulcwp-d-flex ulcwp-flex-column ulcwp-justify-content-center ">
                        <h4><?php echo $single_series->tourName ?></h4>
                        <p> 
                          <?php 

                              $datetimeFormat = 'F j, Y';

                              //$date = new \DateTime();
                              // If you must have use time zones
                              $date = new \DateTime('now', new \DateTimeZone('Asia/Kolkata'));
                              //echo substr($single_series->seriesStartDate, 0, -3);
                              $date->setTimestamp(substr($single_series->seriesStartDate, 0, -3));
                              echo $date->format($datetimeFormat);
                            ?> - 
                            <?php 
                              $date->setTimestamp(substr($single_series->seriesEndDate, 0, -3));
                              echo $date->format($datetimeFormat);
                            ?>
                                    
                          </p>
                      </div>
                      <?php if(!empty( $single_series->Testcount ) || !empty( $single_series->T20count ) || !empty( $single_series->Odicount ) ): ?>
                          <div class="ulcwp-series-right-sec">
                            <div class="ulcwp-series-matchform">
                              <div class="ulcwp-matchform-inner ulcwp-d-flex ulcwp-align-items-center">
                                <?php if(!empty( $single_series->Testcount ) ): ?>
                                  <div class="ulcwp-matchform-detail">
                                    <p>TEST <span><?php echo $single_series->Testcount ?></span></p>
                                  </div>
                                <?php endif; ?>
                                <?php if(!empty( $single_series->T20count ) ): ?>
                                  <div class="ulcwp-matchform-detail">
                                    <p>T20s <span><?php echo $single_series->T20count ?></span></p>
                                  </div>
                                <?php endif; ?>
                                <?php if(!empty( $single_series->Odicount ) ): ?>
                                  <div class="ulcwp-matchform-detail">
                                    <p>ODIs <span><?php echo $single_series->Odicount ?></span></p>
                                  </div>
                                <?php endif; ?>
                              </div>
                            </div>
                          </div>
                      <?php endif; ?>
                    </div>
                  </a>
                </div>
            <?php 
                
              } 
            } 
          ?>
          <div id="all_rows" data-status = "<?php echo get_query_var('tab') ?>" data-type="<?php echo $type ?>">
    
          </div>
      </div>
      <div id="loading"></div>
       
<?php 

      $content = ob_get_clean();
      return $content; 
}